﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class ProviderAvailabilityChargeType
    {
        /// <summary>
        /// Gets or sets the Provider Availability Charge Type id
        /// </summary>
        [Key, Identity]
        public int ProviderAvailabilityChargeTypeId { get; set; }

     

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int Charge { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public DateTime? StartDate { get; set; }
        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime? EndDate { get; set; }
        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }
        /// <summary>
        /// Gets or sets the consultation type id.
        /// </summary>
        public int ConsultationTypeId { get; set; }
        /// <summary>
        /// Gets or sets the parts of day id.
        /// </summary>

        public int? PartsOfDayId { get; set; }

        /// <summary>
        /// Gets or sets the followup days
        /// </summary>
        public int? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the follow up days limit.
        /// </summary>
        public int? FollowUpDaysLimit { get; set; }

    }
}
