﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The visit type.
    /// </summary>
    public class VisitType
    {
        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        [Key, Identity]
        public int VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the visitor name.
        /// </summary>
        public string VisitorName { get; set; }


        /// <summary>
        /// Gets or sets the visit type for.
        /// </summary>
        public string? VisitTypeFor { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        public string RowColor { get; set; }
       
    }
}
