﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class EmergencyEncounter
    {
        /// <summary>
        /// Gets or sets the emergency encounter id.
        /// </summary>
        [Key, Identity]
        public int EmergencyEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Get or sets patient Id
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the abdomen.
        /// </summary>
        public string? EmergencyTriage { get; set; }

        /// <summary>
        /// Gets or sets the additional Labs.
        /// </summary>
        public string? NursingERForm { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

    }
}