﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The issue detail.
    /// </summary>
    public class IssueDetail
    {
        /// <summary>
        /// Gets or sets the issue detail id.
        /// </summary>
        [Key, Identity]
        public int IssueDetailId { get; set; }

        /// <summary>
        /// Gets or sets the issue header id.
        /// </summary>
        public int IssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int ProductId { get; set; }

        /// <summary>
        /// Gets or sets the stock id.
        /// </summary>
        public int StockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }
    }
}
