﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;
    using System;

    /// <summary>
    /// The lab header.
    /// </summary>
    public class LabHeader
    {
        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        [Key, Identity]
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab code.
        /// </summary>
        public string LabCode { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string Signature { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the charge.
        /// </summary>
        public double Charge { get; set; }

        /// <summary>
        /// Gets or sets the in patient charge.
        /// </summary>
       // public double InPatientCharge { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab department identifier.
        /// </summary>
        /// <value>
        /// The lab department identifier.
        /// </value>
        public int LabDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the in patient charges
        /// </summary>
        /// <value>
        /// The In patient charges
        /// </value>
        public double InPatientCharge { get; set; }
    }
}
