﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.Scan.ScanMachineAvailability;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary>
    /// The id proof Service interface.
    /// </summary>
    public interface IScanMachineAvailabilityService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(ScanMachineAvailabilityInsertModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanMachineAvailabilityFilterModel>> FetchAllAsync(ScanMachineAvailabilityFilterModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanMachineAvailabilityFilterModel>> FetchAltAsync(ScanMachineAvailabilityFetchModel model);

        /// <summary>
        /// Fetches selected machine availabilities.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanMachineAvailabilityFilterModel>> FetchMachineAvailabilityAsync(ScanMachineAvailabilityFetchModel model);
        
         /// <summary>
         /// Updates the asynchronous.
         /// </summary>
         /// <param name="model">The model.</param>
         /// <returns></returns>
         Task<int> UpdateAsync(ScanMachineAvailabilityInsertModel model);

       
        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(ScanMachineAvailabilityInsertModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="scanMachineAvailabilityId">
        /// The scan availability.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int? scanMachineAvailabilityId);

        /// <summary>
        /// Fetches selected machine availabilities.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DateWiseMachines>> FetchMachineAvailabilityBasedOnDaysAsync(ScanMachineAvailabilityBasedOnDaysModel model);

        Task<IEnumerable<ScanMachineAvailabilityBasedOnDaysModel>> GetScanTestDuration(int? scanTestMasterId);

        Task<IEnumerable<TimeSpan>> FetchScanAppointmentDetails( int scanMachineMasterId, string appointmentDate);

        /// <summary>
        /// Fetches selected appointment's from time and to time.
        /// </summary>
        /// <param name="scanMachineMasterId">The model.</param>
        /// <param name="appointmentDate">The model.</param>
        /// <param name="locationId">The model.</param>
        /// <returns></returns>

        Task<IEnumerable<AppointmentTimings>> FetchScanAppointmentTimeDetails( int scanMachineMasterId, string appointmentDate, int locationId);



        /// <summary>
        /// The get charge availability async.
        /// </summary>
        /// <param name="ScanMachineAvailabilityId">
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindDateByScanAvailabilityId(int? ScanMachineAvailabilityId);


        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="ScanMachineAvailabilityId">The scan machine availability id.</param>
        /// <param name="FromDate">The from date.</param>
        /// <param name="ToDate">The to date.</param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CancelAvailabilityAsync(int? ScanMachineAvailabilityId, string FromDate, string ToDate);

        /// <summary>
        /// Fetches selected machine slots.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanSlotModel>> FetchMachineSlotsAsync(ScanMachineAvailabilityBasedOnDaysModel model);

    }
}
