﻿namespace Hims.Shared.UserModels.NurseShift.Bed
{
    /// <summary>
    /// 
    /// </summary>
    public class BasicBedModel
    {
        /// <summary>
        /// Gets or sets the name of the bed.
        /// </summary>
        /// <value>
        /// The name of the bed.
        /// </value>
        public string BedName { get; set; }

        /// <summary>
        /// Gets or sets the name of the room.
        /// </summary>
        /// <value>
        /// The name of the room.
        /// </value>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the name of the floor.
        /// </summary>
        /// <value>
        /// The name of the floor.
        /// </value>
        public string FloorName { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        /// <value>
        /// The value.
        /// </value>
        public int BedId { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        /// <value>
        /// The admission no.
        /// </value>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        /// <value>
        /// The patient age.
        /// </value>
        public int PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the name of the priority.
        /// </summary>
        /// <value>
        /// The name of the priority.
        /// </value>
        public string PriorityName { get; set; }

        /// <summary>
        /// Gets or sets the priority icon.
        /// </summary>
        /// <value>
        /// The priority icon.
        /// </value>
        public string PriorityIcon { get; set; }

        /// <summary>
        /// Gets or sets the color of the priority.
        /// </summary>
        /// <value>
        /// The color of the priority.
        /// </value>
        public string PriorityColor { get; set; }

        /// <summary>
        /// Gets or sets the patient image.
        /// </summary>
        /// <value>
        /// The patient image.
        /// </value>
        public string PatientImage { get; set; }
    }
}
