﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class DashboardWidget
    {
        /// <summary>
        /// Gets or sets the widget id.
        /// </summary>
        [Key, Identity]
        public int DashboardWidgetId { get; set; }

        /// <summary>
        /// Gets or sets the widget name.
        /// </summary>
        public string Name { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the widget type id.
        /// </summary>
        public int DashboardWidgetTypeId { get; set; }

        /// <summary>
        /// Gets or sets the dashboard widget count type identifier.
        /// </summary>
        /// <value>
        /// The dashboard widget count type identifier.
        /// </value>
        public int? DashboardWidgetCountTypeId { get; set; }

        /// <summary>
        /// Gets or sets the stored procedure name.
        /// </summary>
        public string StoredProcedureName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        /// <value>
        /// The icon.
        /// </value>
        public string Icon { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public bool Active { get; set; }
    }
}
