﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Laboratory;

    /// <summary>
    /// The lab department service interface.
    /// </summary>
    public interface ILabDepartmentService
    {
        /// <summary>
        /// Modifies the department asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyDepartmentAsync(LabDepartmentModel model);

        /// <summary>
        /// Fetches all department asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabDepartmentModel>> FetchAllDepartmentAsync(LabDepartmentModel model);

        /// <summary>
        /// Modifies the lab status.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyLabStatus(LabDepartmentModel model);
    }
}
