﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The internal medicine.
    /// </summary>
    public enum InternalMedicine
    {
        /// <summary>
        /// The problem list.
        /// </summary>
        ProblemList = 1,

        /// <summary>
        /// The cheif complaints.
        /// </summary>
        CheifComplaints,

        /// <summary>
        /// The follow up.
        /// </summary>
        FollowUp,

        /// <summary>
        /// The medications.
        /// </summary>
        Medications,

        /// <summary>
        /// The notes.
        /// </summary>
        Notes,

        /// <summary>
        /// The vitals.
        /// </summary>
        Vitals,

        /// <summary>
        /// The social history.
        /// </summary>
        SocialHistory,

        /// <summary>
        /// The family medical history.
        /// </summary>
        FamilyMedicalHistory,

        /// <summary>
        /// The diagnosis.
        /// </summary>
        Diagnosis,

        /// <summary>
        /// The general advice.
        /// </summary>
        GeneralAdvice,

        /// <summary>
        /// The heent.
        /// </summary>
        Heent,

        /// <summary>
        /// The skin.
        /// </summary>
        Skin,

        /// <summary>
        /// The abdomen.
        /// </summary>
        Abdomen,

        /// <summary>
        /// The musculoskeletal.
        /// </summary>
        Musculoskeletal,

        /// <summary>
        /// The neurology.
        /// </summary>
        Neurology,

        /// <summary>
        /// The Extremities.
        /// </summary>
        Extremities,

        /// <summary>
        /// The respiratory.
        /// </summary>
        Respiratory,

        /// <summary>
        /// The ekg.
        /// </summary>
        Ekg,

        /// <summary>
        /// The cardio vascular.
        /// </summary>
        CardioVascular,

        /// <summary>
        /// The allergies.
        /// </summary>
        Allergies,

        /// <summary>
        /// The hospitalization.
        /// </summary>
        Hospitalization,

        /// <summary>
        /// The preventive care.
        /// </summary>
        PreventiveCare,

        /// <summary>
        /// The immunizations.
        /// </summary>
        Immunizations,

        /// <summary>
        /// The medication problems.
        /// </summary>
        MedicationProblems,

        /// <summary>
        /// The current medications.
        /// </summary>
        CurrentMedications,

        /// <summary>
        /// The review of systems.
        /// </summary>
        ReviewOfSystems,

        /// <summary>
        /// The medication comments.
        /// </summary>
        MedicationComments
    }
}
