﻿using System;
namespace Hims.Shared.UserModels
{
    public class ModulesMasterModel
    {
        /// <summary>
        /// Gets or sets the ModulesMasterId.
        /// </summary>
        public int ModulesMasterId { get; set; }
        /// <summary>
        /// Gets or sets the ModuleName.
        /// </summary>
        public string ModuleName { get; set; }
        /// <summary>
        /// Gets or sets the ModuleIcon.
        /// </summary>
        public string ModuleIcon { get; set; }
        /// <summary>
        /// Gets or sets the ModuleDescription.
        /// </summary>
        public string ModuleDescription { get; set; }
        /// <summary>
        /// Gets or sets the CreatedBy.
        /// </summary>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the CreatedDate.
        /// </summary>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the ModifiedBy.
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets theModifiedDate.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the CreatedByName.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the ModifiedByName.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the type of the package.
        /// </summary>
        /// <value>
        /// The type of the package.
        /// </value>
        public string PackageType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is charge category applicable.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is charge category applicable; otherwise, <c>false</c>.
        /// </value>
        public bool? IsChargeCategoryApplicable { get; set; }

        /// <summary>
        /// Gets or sets the is doctor charge category applicable.
        /// </summary>
        /// <value>
        /// The is doctor charge category applicable.
        /// </value>
        public bool? IsDoctorChargeCategoryApplicable { get; set; }

        /// <summary>
        /// Gets or sets the is package applicable.
        /// </summary>
        /// <value>
        /// The is package applicable.
        /// </value>
        public bool? IsPackageApplicable { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
    }

}
