﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class Charge
    {
        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        [Key, Identity]
        public int ChargeId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int ChargeGroupId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int RepeatTypeId { get; set; }

        /// <summary>
        /// Gets or sets the automatic type identifier.
        /// </summary>
        /// <value>
        /// The automatic type identifier.
        /// </value>
        public int? AutomaticTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge type identifier.
        /// </summary>
        /// <value>
        /// The charge type identifier.
        /// </value>
        public int? ChargeTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ModulesMasterId { get; set; }

    }
}
