﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class Coupon
    {
        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        [Key, Identity]
        public int CouponId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string CouponCode { get; set; }

        /// <summary>
        /// Gets or sets the coupon type.
        /// </summary>
        public char CouponType { get; set; }

        /// <summary>
        /// Gets or sets the coupon value.
        /// </summary>
        public decimal CouponValue { get; set; }

        /// <summary>
        /// Gets or sets the valid from.
        /// </summary>
        public DateTime ValidFrom { get; set; }

        /// <summary>
        /// Gets or sets the valid to.
        /// </summary>
        public DateTime ValidTo { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        
        /// <summary>
        /// Gets or sets the allowed per user.
        /// </summary>
        public int? AllowedPerUser { get; set; }
        
        /// <summary>
        /// Gets or sets the Provider Ids.
        /// </summary>
        public string? NotAllowedProviderIds { get; set; }

        /// <summary>
        /// Gets or sets the Patient Ids.
        /// </summary>
        public string? NotAllowedPatientIds { get; set; }

        /// <summary>
        /// Gets or sets the Allowed for first appointment value.
        /// </summary>
        public bool? AllowedForFirstAppointment { get; set; }

        /// <summary>
        /// Gets the description.
        /// </summary>
        public string? Description { get; set; }
    }
}
