﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class GynEncounter
    {
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        [Key, Identity]
        public int GynEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Get or sets patient Id
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime EncounterDate { get; set; }

        /// <summary>
        /// Gets or sets the abdomen.
        /// </summary>
        public string? Abdomen { get; set; }

        /// <summary>
        /// Gets or sets the additional Labs.
        /// </summary>
        public string? AdditionalLabs { get; set; }

        /// <summary>
        /// Gets or sets the birth control.
        /// </summary>
        public string? BirthControl { get; set; }

        /// <summary>
        /// Gets or sets the breast.
        /// </summary>
        public string? Breast { get; set; }

        /// <summary>
        /// Gets or sets the breast screening.
        /// </summary>
        public string? BreastScreening { get; set; }

        /// <summary>
        /// Gets or sets the cancer history.
        /// </summary>
        public string? CancerHistory { get; set; }

        /// <summary>
        /// Gets or sets the cardio vascular.
        /// </summary>
        public string? Cardiovascular { get; set; }

        /// <summary>
        /// Gets or sets the gynHistory.
        /// </summary>
        public string? GynHistory { get; set; }

        /// <summary>
        /// Gets or sets the gynLabs.
        /// </summary>
        public string? GynLabs { get; set; }

        /// <summary>
        /// Gets or sets the gynUltraSound.
        /// </summary>
        public string? GynUltraSound { get; set; }

        /// <summary>
        /// Gets or sets the heent.
        /// </summary>
        public string? Heent { get; set; }

        /// <summary>
        /// Gets or sets the lastBreastUltraSound.
        /// </summary>
        public string? LastBreastUltraSound { get; set; }

        /// <summary>
        /// Gets or sets the lastDexaScan.
        /// </summary>
        public string? LastDexaScan { get; set; }

        /// <summary>
        /// Gets or sets the lastMammogram.
        /// </summary>
        public string? LastMammogram { get; set; }

        /// <summary>
        /// Gets or sets the lastPelvicUltraSound.
        /// </summary>
        public string? LastPelvicUltraSound { get; set; }

        /// <summary>
        /// Gets or sets the lymphatic.
        /// </summary>
        public string? Lymphatic { get; set; }

        /// <summary>
        /// Gets or sets the menopausal History.
        /// </summary>
        public string? MenopausalHistory { get; set; }

        /// <summary>
        /// Gets or sets the Mensutral history.
        /// </summary>
        public string? MensutralHistory { get; set; }

        /// <summary>
        /// Gets or sets the musculo skeletal.
        /// </summary>
        public string? MusculoSkeletal { get; set; }

        /// <summary>
        /// Gets or sets the patient deferred.
        /// </summary>
        public string? PatientDeferred { get; set; }

        /// <summary>
        /// Gets or sets the pelvic.
        /// </summary>
        public string? Pelvic { get; set; }

        /// <summary>
        /// Gets or sets the physical exam.
        /// </summary>
        public string? PhysicalExam { get; set; }

        /// <summary>
        /// Gets or sets the respiratory.
        /// </summary>
        public string? Respiratory { get; set; }

        /// <summary>
        /// Gets or sets the skin.
        /// </summary>
        public string? Skin { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the gyneac card.
        /// </summary>
        public string? GyneacCard { get; set; }

        /// <summary>
        /// Gets or sets the gyneac orders.
        /// </summary>
        public string? GynaecOrders { get; set; }

        /// <summary>
        /// Gets or sets the gyuniui.
        /// </summary>
        public string? GynIUI { get; set; }

        /// <summary>
        /// Gets or sets the gynaecVisit.
        /// </summary>
        public string? GynaecVisit { get; set; }
        /// <summary>
        /// Gets or sets the procedure.
        /// </summary>
        public string? Procedure{ get; set; }
        /// <summary>
        /// Gets or sets the gyneac partner
        /// </summary>
        public string? GyneacPartner { get; set; }

        /// <summary>
        /// Gets or sets the gynaecVisit.
        /// </summary>
        public string? ProformaForOasi { get; set; }
        /// <summary>
        /// Gets or sets the gynaecVisit.
        /// </summary>
        public string? FamilyHistory { get; set; }
        /// <summary>
        /// The gynaecvisit.
        /// </summary>
        /// <summary>
        /// Gets or sets the gynaecVisit.
        /// </summary>
        public string? ProblemList { get; set; }
        /// <summary>
        /// The gynaecvisit.
        /// </summary>
        /// <summary>
        /// Gets or sets the gynaecVisit.
        /// </summary>
        public string? Surgeries { get; set; }
        /// <summary>
        /// The gynaecvisit.

        public string? BirthHistory { get; set; }

       
        public string? Allergies { get; set; }
        public string? OrderPrescription { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
             public string? GyneacAdmissionSheet { get; set; }
        public string? GyneacSurgery { get; set; }
        public string? GyneacDiscargeSummary { get; set; }
        public string? Colposcopic { get; set; }
        public string? Ectopic { get; set; }
        public string? SpeacialFeature { get; set; }
        /// <summary>
        /// Get or sets referral form
        /// </summary>
        public string? ReferralForm { get; set; }
        /// <summary>
        public string? Measure { get; set; }
        public string? RefferalOrder { get; set; }
        // <summary>
        /// Get or sets measure common data
        /// </summary>
        public string? MeasureCommonData { get; set; } 
        public string? ScanAppointmentDetails { get; set; }
        public string? OutSideTests { get; set; }
        // <summary>
        /// Get or sets measure common data
        /// </summary>
        public string? Reminder { get; set; }
        

    }
}