﻿namespace Hims.Domain.Entities.Inventory
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The inventory department consumption.
    /// </summary>
    public class InventoryDepartmentConsumption
    {
        /// <summary>
        /// Gets or sets the inventory department consumption identifier.
        /// </summary>
        /// <value>
        /// The inventory department consumption identifier.
        /// </value>
        [Key,Identity]
        public int InventoryDepartmentConsumptionId { get; set; }

        /// <summary>
        /// Gets or sets the inventory departmental stock identifier.
        /// </summary>
        /// <value>
        /// The inventory departmental stock identifier.
        /// </value>
        public int InventoryDepartmentalStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity consumed.
        /// </summary>
        /// <value>
        /// The quantity consumed.
        /// </value>
        public int QuantityConsumed { get; set; }

        /// <summary>
        /// Gets or sets the consumed by.
        /// </summary>
        /// <value>
        /// The consumed by.
        /// </value>
        public int ConsumedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the quantity before consumption.
        /// </summary>
        /// <value>
        /// The quantity before consumption.
        /// </value>
        public int QuantityBeforeConsumption { get; set; }

        /// <summary>
        /// Gets or sets the reason for consumption.
        /// </summary>
        /// <value>
        /// The reason for consumption.
        /// </value>
        public string ReasonForConsumption { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
    }
}
