﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The pharmacy purchase return detail.
    /// </summary>
    public class PharmacyPurchaseReturnDetail
    {
        /// <summary>
        /// Gets or sets the pharmacy purchase return detail id.
        /// </summary>
        [Key, Identity]
        public int PharmacyPurchaseReturnDetailId { get; set; }
        
        /// <summary>
        /// Gets or sets the pharmacy purchase detail id.
        /// </summary>
        public int PharmacyPurchaseDetailId { get; set; }
        
        /// <summary>
        /// Gets or sets the pharmacy purchase return header id.
        /// </summary>
        public int PharmacyPurchaseReturnHeaderId { get; set; }
       
        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }
       
        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int ReturnQuantity { get; set; }
       
        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }
        
        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public double TaxPercentage { get; set; }
       
        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }
      
        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }
        
        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }
        
        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }
    }
}
