﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The pharmacy ware house user.
    /// </summary>
    public class PharmacyWareHouseUser
    {
        /// <summary>
        /// Gets or sets the pharmacy ware house user identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house user identifier.
        /// </value>
        [Key, Identity]
        public int PharmacyWareHouseUserId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the accoun identifier.
        /// </summary>
        /// <value>
        /// The accoun identifier.
        /// </value>
        public int AccountId { get; set; }
    }
}
