﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class ProviderAvailabilitySlot
    {
        /// <summary>
        /// Gets or sets the provider availability slot id.
        /// </summary>
        [Key, Identity]
        public int ProviderAvailabilitySlotId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDay { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndTime { get; set; }

        /// <summary>
        /// Gets or sets the free follow up days.
        /// </summary>
        public int? FreeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the fee followup days limit.
        /// </summary>
        public int? FreeFollowUpDaysLimit { get; set; }
    }
}
