﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class ProviderAvailabilityVisitType
    {

        /// <summary>
        /// Gets or sets the Provider Availability Visit Id
        /// </summary>
        [Key, Identity]
        public int ProviderAvailabilityVisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int? Duration { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        public int? ProviderId { get; set; }
        public int? SpecializationId { get; set; }
        public int? LocationId { get; set; }
    }
}
