﻿namespace Hims.Domain.Entities.ProviderMedication
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider medication map
    /// </summary>
    public class ProviderMedicationMap
    {
        /// <summary>
        /// Gets or sets the provider medication map identifier.
        /// </summary>
        /// <value>
        /// The provider medication map identifier.
        /// </value>
        [Key, Identity]
        public int ProviderMedicationMapId { get; set; }

        /// <summary>
        /// Gets or sets the provider medication master identifier.
        /// </summary>
        /// <value>
        /// The provider medication master identifier.
        /// </value>
        public int ProviderMedicationMasterId { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ProviderMedicationMap"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
    }
}
