﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Hims.Shared.Dapper.Attributes;

    public class SurgeryService
    {
        [Key, Identity]
        public int SurgeryServiceId { get; set; }

        public int? SurgeryId { get; set; }

        public int? AdmissionId { get; set; }

        public int? AppointmentId { get; set; }

        public int Unit { get; set; }

        public double? Cost { get; set; }

        public bool IsMain { get; set; }

        public int? ChargeCategoryId { get; set; }

        public int? AdmissionPackageId { get; set; }

        public int? PackageModuleDetailId { get; set; }

        public int? UsedQuantity { get; set; }

        public double? UsedCost { get; set; }

        public string Notes { get; set; }

        public bool Active { get; set; }

        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        public int? ModifiedBy { get; set; }

        public DateTime? ModifiedDate { get; set; }
    }
}
