﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class TicketType
    {
        /// <summary>
        /// Gets or sets the ticket type identifier.
        /// </summary>
        /// <value>
        /// The ticket type identifier.
        /// </value>
        [Key, Identity]
        public int TicketTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the ticket type.
        /// </summary>
        /// <value>
        /// The name of the ticket type.
        /// </value>
        public string TicketTypeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="TicketType"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
    }
}
