﻿using Hims.Shared.Library.Enums;

namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary> The chat.</summary>
    public class Timeline
    {
        /// <summary>
        /// Gets or sets the timeline id.
        /// </summary>
        [Key, Identity]
        public int TimelineId { get; set; }

        /// <summary>
        /// Gets or sets the timeline action id.
        /// </summary>
        public TimelineAction TimelineActionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }
    }
}
