﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The wallet.
    /// </summary>
    public class Wallet
    {
        /// <summary>
        /// Gets or sets the wallet id.
        /// </summary>
        [Key, Identity]
        public int WalletId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the credited amount.
        /// </summary>
        public double? CreditedAmount { get; set; }

        /// <summary>
        /// Gets or sets the debited amount.
        /// </summary>
        public double? DebitedAmount { get; set; }

        /// <summary>
        /// Gets or sets the credited reason.
        /// </summary>
        public string? CreditedFor { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
    }
}