﻿using System.Collections.Generic;

namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.UserModels.GataPass;

    /// <summary>
    /// The CompanyService interface.
    /// </summary>
    public interface IGatePassService
    {      
        /// <summary>
        /// The insert company async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertAsync(InsertModel model);
       
        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(InsertModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<InsertModel> FetchAsync(InsertModel model);

    }
}
