﻿using Hims.Domain.Entities.Enums;

namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary> The chat.</summary>
    public class FinalBillServiceOrder
    {
        /// <summary>
        /// Gets or sets the final bill service order identifier.
        /// </summary>
        /// <value>
        /// The final bill service order identifier.
        /// </value>
        [Key, Identity]
        public int FinalBillServiceOrderId { get; set; }

        /// <summary>
        /// Gets or sets the final bill identifier.
        /// </summary>
        /// <value>
        /// The final bill identifier.
        /// </value>
        public int FinalBillId { get; set; }

        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public int? ChargeId { get; set; }

        /// <summary>
        /// Gets or sets the product identifier.
        /// </summary>
        /// <value>
        /// The product identifier.
        /// </value>
        public int? ProductId { get; set; }

        /// <summary>
        /// Gets or sets the package identifier.
        /// </summary>
        /// <value>
        /// The package identifier.
        /// </value>
        public int? PackageId { get; set; }

        /// <summary>
        /// Gets or sets the package identifier.
        /// </summary>
        /// <value>
        /// The package identifier.
        /// </value>
        public int? PackageModuleId { get; set; }

        /// <summary>
        /// Gets or sets the product identifier.
        /// </summary>
        /// <value>
        /// The product identifier.
        /// </value>
        public double? DiscountPercentage { get; set; }

        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        /// <value>
        /// The unit.
        /// </value>
        public int Unit { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the special provider identifier.
        /// </summary>
        /// <value>
        /// The special provider identifier.
        /// </value>
        public int? ChargeTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge type main identifier.
        /// </summary>
        /// <value>
        /// The charge type main identifier.
        /// </value>
        public int? ChargeTypeMainId { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        /// <value>
        /// The notes.
        /// </value>
        public string Notes { get; set; }
    }
}
