﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The insurance company.
    /// </summary>
    public class InsuranceCompany
    {
        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        [Key, Identity]
        public int InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the contact person name.
        /// </summary>
        public string ContactPersonName { get; set; }

        /// <summary>
        /// Gets or sets the contact period from.
        /// </summary>
        public DateTime ContactPeriodFrom { get; set; }

        /// <summary>
        /// Gets or sets the contact period to.
        /// </summary>
        public DateTime ContactPeriodTo { get; set; }

        /// <summary>
        /// Gets or sets the contact person mobile.
        /// </summary>
        public string ContactPersonMobile { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
