﻿#nullable enable
namespace Hims.Domain.Helpers
{
    using System;
    using System.Threading.Tasks;
    using RestSharp;
    using Shared.EntityModels;

    /// <summary>
    /// The sinch interface.
    /// </summary>
    public interface IKaleyraSMSHelper
    {
        /// <summary>
        /// The send SMS async.
        /// </summary>
        /// <param name="mobile">
        ///     The mobile.
        /// </param>
        /// <param name="body">
        ///     The body.
        /// </param>
        /// <param name="countryModel">
        ///     The country Model.
        /// </param>
        /// <param name="templateId">
        ///     The country Model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse?> SendSMSAsync(string mobile, string body, CountryModel countryModel, string templateId);

        /// <summary>
        /// Sends the report SMS asynchronous.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="body">The body.</param>
        /// <param name="countryModel">The country model.</param>
        /// <param name="templateId">The template identifier.</param>
        /// <param name="url">The URL.</param>
        /// <returns></returns>
        Task<Tuple<IRestResponse?, string>> SendReportSMSAsync(string mobile, string body, CountryModel countryModel, string templateId, string url);
        Task<Tuple<IRestResponse?, string>> SendPdfLinkSMSAsync(string patientMobile, string messageBody, CountryModel countryModel, string v, string createPdfLink);
    }
}
