﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Filters;
    using Shared.Library;

    /// <summary>
    /// The ResourceService interface.
    /// </summary>
    public interface IResourceService
    {
        /// <summary>
        /// Locationses the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> LocationsAsync();

        Task<IEnumerable<Resource>> FetchAccountDynamicAsync(string type, string value, int? locationId);

        /// <summary>
        /// Fetches the nurses.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchNurses();

        /// <summary>
        /// Providers the with charges asynchronous.
        /// </summary>
        /// <param name="searchParam">The search parameter.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> ProviderWithChargesAsync(string searchParam, bool isAdmission);

        /// <summary>
        /// The roles async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> RolesAsync();

        /// <summary>
        /// The roles async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> RolesWithOutPatient();

        /// <summary>
        /// The countries async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> CountriesAsync();

        /// <summary>
        /// The log types async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LogTypesAsync();

        /// <summary>
        /// The services async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ServicesAsync();

        /// <summary>
        /// The specializations async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> SpecializationsAsync();
        /// <summary>
        /// The specializations async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LocationSpecializationsAsync(int? locationId, int providerId);

        /// <summary> The lab order async.</summary>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<IEnumerable<Resource>> LabOrderAsync();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> RadiologyAsync();

        /// <summary>
        /// The Insurance Companies async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> InsuranceCompaniesAsync();

        /// <summary>
        /// The Relationships.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> Relationships();

        /// <summary>
        /// The DocumentCategories.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        List<Resource> DocumentCategories();

        /// <summary>
        /// The Provider Appointment Dates specializations async.
        /// </summary>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ProviderAppointmentDatesAsync(int providerId);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// /// <param name="isBabyRegistration">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> PatientsAsync(string? searchParam, int? providerId, bool? isBabyRegistration);

        /// <summary>The scan patients async.</summary>
        /// <param name="searchParam">The search param.</param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> PatientsScanAsync(string? searchParam);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> InPatientsAsync(string? searchParam, int locationId);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> AppointmentsAsync(string? searchParam);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PatientModel>> FetchPatientsAllAsync(string? searchParam, int? providerId);

        /// <summary>
        /// The departments async.
        /// </summary>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> DepartmentsAsync(int? providerId, int? locationId);

        /// <summary>
        /// The departments async.
        /// </summary>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> DoctorSpecializationAsync(int? providerId, int? locationId);

        /// <summary>
        /// The surgery types async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> SurgeryTypesAsync();

        /// <summary>
        /// The ICD codes async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ICDCodesAsync(string searchParam);

        /// <summary>
        /// The fetch icd.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ICDCodesAsync(int? providerId);

        /// <summary>
        /// The fetch general advice.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> GeneralAdvicesAsync(int? providerId);

        /// <summary>
        /// The CPT codes async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> CPTCodesAsync(string searchParam);

        /// <summary>
        /// The lookups async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LookupsAsync(string searchParam);

        /// <summary>
        /// The lookup values async.
        /// </summary>
        /// <param name="lookupValueName">
        /// The lookup value name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LookupValuesBasedOnLookupNameAsync(string lookupValueName);

        /// <summary>
        /// The lookup value async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <param name="lookupId">
        /// The lookup Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LookupValuesAsync(string searchParam, int? lookupId);

        /// <summary>
        /// The fetch problem list async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProblemListAsync(string searchParam);

        /// <summary>
        /// The masters details async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> MastersAsync(string searchParam);

        /// <summary>
        /// The masters details async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <param name="locationId">
        /// The lookup Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> Masters1Async(string searchParam, int? locationId);

        /// <summary>
        /// The fetch practice locations.
        /// </summary>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> PracticeLocationsAsync(int countryId);
        Task<IEnumerable<Resource>> PracticeAsync();
        /// <summary>
        /// The fetch provider location.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ProviderLocationsAsync(int providerId, int? specializationId, int? locationId);

        /// <summary>
        /// The drugs async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <param name="searchValue">
        /// The search Value.
        /// </param>
        /// <param name="medicineSearchType">
        /// The medicine Search Type.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> DrugsAsync(string searchParam, string searchValue, string medicineSearchType);

        /// <summary>
        /// The fetch based on role.
        /// </summary>
        /// <param name="roleId">
        /// The role id.
        /// </param>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchBasedOnRole(int roleId, string searchParam);

        /// <summary>
        /// The fetch all users.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllUsers();

        /// <summary>
        /// The fetch lab orders.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LabOrdersAsync(int? providerId);

        /// <summary>
        /// The fetch radiology orders.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> RadiologyOrdersAsync(int? providerId);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ProviderAsync(string searchParam, int? providerId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProvider(int? providerId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProviders(int? departmentId, int? locationId);

        /// <summary>
        /// The fetch admin and support user.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAdminSuperAdminUsers();

        /// <summary>
        /// The fetch languages.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLanguagesAsync();

        /// <summary>
        /// The fetch languages.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchQuestionAsync();

        /// <summary>
        /// The fetch users.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchUsersAsync();

        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPatientAsync();

        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<FeedbackModel>> PatientAsync(FeedbackModel model);

        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchDepartmentAsync();
        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProviderDepartmentAsync();

        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPharmacyCategoriesAsync();

        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPharmacyCompaniesAsync();

        /// <summary>
        /// The fetch pharmacy products async.
        /// </summary>
        /// <param name="categoryId"></param>
        /// <param name="searchTerm"></param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> FetchPharmacyProductsAsync(int? categoryId, string searchTerm);

        /// <summary>
        /// The fetch pharmacy products async.
        /// </summary>
        /// <param name="CategoryName"></param>
        /// <param name="searchTerm"></param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> FetchPharmacyProductAsync(string CategoryName, string searchTerm);

        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchReceiptionistReportsAsync(string roleId);

        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchRolesAllAsync(string roleId);


        /// <summary>
        /// The fetch instructions.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchInstructionsAsync();

        /// <summary>
        /// The lookups async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> EncounterLookupsAsync(string searchParam);

        /// <summary>
        /// The lookup values async.
        /// </summary>
        /// <param name="lookupValueName">
        /// The lookup value name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> EncounterLookupValuesAsync(string lookupValueName);

        /// <summary>
        /// The lookup value async.
        /// </summary>
        /// <param name="searchParam">
        /// The search Param.
        /// </param>
        /// <param name="lookupId">
        /// The lookup Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> EncounterLookupValuesAsync(string searchParam, int lookupId);

        /// <summary>
        /// The fetch patient doctors async.
        /// </summary>
        /// <param name="patientId">
        /// The patient id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<List<Resource>> FetchPatientDoctorsAsync(int patientId, int? locationId);

        /// <summary>
        /// The fetch patient doctors async.
        /// </summary>
        /// <param name="patientId">
        /// The patient id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<List<Resource>> FetchPatientAdmissionDoctorsOnlyAsync(int patientId, int locationId);

        /// <summary>
        /// The fetch patient doctors async.
        /// </summary>
        /// <param name="patientId">
        /// The patient id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<List<Resource>> FetchPatientAppointmentDoctorsOnlyAsync(int patientId, int locationId);

        /// <summary>
        /// The pharmacy log types async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> PharmacyLogTypesAsync();
        /// <summary>
        /// The inventory log types async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> InventoryLogTypesAsync();
        /// <summary>
        /// The lab log types async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LabLogTypesAsync();

        /// <summary>
        /// The scan log types async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ScanLogTypesAsync();

        /// <summary>
        /// The inventory fetch discharge status async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchDischargeStatusAsync();

        /// <summary>
        /// The  fetch lab name.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLabNames();

        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProviderAsync(int? locationId, int providerId);
        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ProviderSchdule(int? locationId);


        /// <summary>
        /// Widgets the types asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> WidgetTypesAsync();

        /// <summary>
        /// The fetch pay type async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> FetchPayTypeAsync(bool? isSalucro);

        /// <summary>
        /// The fetch of all pay types.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllPayTypesAsync(bool onlyActive);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> WidgetsAsync(string? searchParam);

        /// <summary>
        /// The countries async.
        /// </summary>
        /// <param name="cId">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> StatesAsync(int cId);

        /// <summary>
        /// The countries async.
        /// </summary>
        /// <param name="sId">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> CitiesAsync(int sId);

        /// <summary>
        /// The packages async.
        /// </summary>
        /// <param name="id">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> PackageAsync(int id);

        /// <summary>
        /// The demand products async.
        /// </summary>
        /// <param name="id">
        /// The search param.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> DemandProductsAsync();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchFloors(int locationId);

        /// <summary>
        /// The fetch of all floor names.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllFloors();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchWards(int? floordId);

        /// <summary>
        /// The fetch of all ward names.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllWards();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchRooms(int? wardId);

        /// <summary>
        /// The fetch of all room names.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllRooms(int? location);

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchBeds(int? roomId);

        /// <summary>
        /// The fetch of all bed names.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllBeds();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchBedStatus();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<BedManagementFilterModel>> FetchBedsResource(BedManagementFilterModel model);

        /// <summary>
        /// The image async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchImages(int? imageId);

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchShifts();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchSlots(int shiftId);

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchInsuranceTypes();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchHowDidYouKnowAsync();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchEducationAsync();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchOccupationAsync();

        /// <summary>
        /// The radiology async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPatientInsurances(int patientId);


        /// <summary>
        /// Fetches the retail store asynchronous.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchRetailStoreAsync(int? locationId);

        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPharmaUsers();

        /// <summary>
        /// Fetches the ware house asynchronous.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchWareHouseAsync(int? locationId);


        /// <summary>
        /// Fetches the inventory ware house asynchronous.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchInventoryWareHouseAsync(int? locationId);


        /// <summary>
        /// The  fetch meal types.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchMealTypeAsync();



        /// <summary>
        /// The  fetch meal types.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ProviderPracticeLocationAsync(int? locationId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> AdmissionProviderAsync(int? departmentId, int? locationId);

        /// <summary>
        /// The problems async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProblemsAsync();

        /// <summary>
        /// The goals async.
        /// </summary>
        /// <param name="problemIds">
        /// The problem Ids.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchGoalsAsync(string problemIds);

        /// <summary>
        /// The objectives async.
        /// </summary>
        /// <param name="goalIds">
        /// The goal Ids.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchObjectivesAsync(string goalIds);

        /// <summary>
        /// The objectives async.
        /// </summary>
        /// <param name="objectiveIds">
        /// The objective Ids.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchInterventionAsync(string objectiveIds);

        /// <summary>
        /// The objectives async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationsAsync();

        /// <summary>
        /// The shifts async.
        /// </summary>
        /// <param name="locationId">
        /// The location Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> EmployeeShiftsAsync(int? locationId);

        /// <summary>
        /// Fetches the HWS masters asynchronous.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchHwsMastersAsync(int locationId);

        /// <summary>
        /// The fetch of all hwc names.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllHWCPatients();

        /// <summary>
        /// Dashboard Widgets count types asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> WidgetCountTypesAsync();

        /// <summary>
        /// The appointment type async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> AppointmentTypeAsync();

        /// <summary>
        /// The appointment type async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ReferredByNamesAsync();

        /// <summary>
        /// The fetch scan machine async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ScanMachineAsync(int? locationId);



        /// <summary>
        /// The fetch scan machine async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanMachineMasterAsync(int? locationId);

        /// <summary>
        /// The fetch of all Scan Machines.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllScanMachines();

        /// <summary>
        /// The fetch of all Scan Machines.
        /// </summary>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanMachineFilterMachines(int? locationId);

        /// <summary>
        /// The fetch of all ScanTests.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAllScanTests();

        /// <summary>
        /// The fetch of all Sca Machine Filter Tests.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanMachineFilterTests(int? locationId);

        /// <summary>
        /// The fetch of all ScanTests.
        /// </summary>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationScanTests(int? locationId);

        /// <summary>
        /// Fetches the lab departments asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchLabDepartmentsAsync();

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FindTestAsync(int? scanMachineMasterId, int? locationId);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ActivePatientsAsync(string? searchParam, int? providerId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAccountAsync(int? accountId, int? locationId);

        /// <summary>
        /// Fetches the provider account asynchronous.
        /// </summary>
        /// <param name="accountId">The account identifier.</param>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchProviderAccountAsync(int? accountId, int? locationId);

        /// <summary>
        /// Fetches the providers for scan asynchronous.
        /// </summary>
        /// <param name="accountId">The account identifier.</param>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchScanProviderAccountAsync(int? accountId, int? locationId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchNotificationTypes();

        /// <summary>
        /// The fetch radiology orders.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ProviderSpecializationAsync(int? providerId, int? locationId);
        /// <summary>
        /// The fetch inventory product
        /// </summary>
        /// <param name="categoryId"></param>
        /// <param name="searchTerm"></param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchInventoryProductsAsync(int? categoryId, string searchTerm);

        /// <summary>
        /// The fetch pay category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPayCategory();

        /// <summary>
        /// The fetch pay category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchConsultationType();

        /// <summary>
        /// The fetch pay category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAvailabilityChargeType(int? chargeId, int? providerAvailabilitySlotId);

        /// <summary>
        /// The fetch provider location.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="locationId"></param>
        /// <param name="appointmentDate"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ProviderAvailabilityAsync(int providerId, int? specializationId, int? locationId, int? consultationTypeId, string appointmentDate);

        /// <summary>
        /// The fetch provider location.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> PartsOfDayAsync(int providerId, int? specializationId, int? locationId, string? startDate, string? endDate);

        /// <summary>
        /// The fetch menu accessed roles.
        /// </summary>
        /// <param name="url">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> MenuAccessedRolesAsync(string url);
        /// <summary>
        /// The fetch menu accessed roles.
        /// </summary>
        /// <param name="url">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPatientByFilter(AppointmentFilterModel model);

        /// <summary>
        /// The fetch receipt area async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> FetchReceiptAreaAsync();
        /// <summary>
        /// The fetch receipt area async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> FetchReceiptAreaAsyncs();

        /// <summary>
        /// The fetch receipt area async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> ActiveStatusAsync();
        /// <summary>
        /// The fetch receipt area async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<Resource>> SpecializationsForProviderAcailabilityAsync(int? locationId);

        /// <summary>
        /// Fetches the pathology providers.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchPathologyProviders(int? locationId);

        /// <summary>
        /// Locationses the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> EncounterTypeAsync();

        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationScanTestAsync(int? locationId, int? scanMachineMasterId);
        /// <summary>
        /// The fetch of scan machines based on location.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationScanMachineAsync(int? locationId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanMachinesTestsAsync(string? scanTestMasterId, string? scanMachineMasterId);

        /// <summary>
        /// The fetch Scan Classification.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanClassification(int? locationId);

        /// <summary>
        /// The fetch Scan sub Classification.
        /// </summary>
        /// <param name="classificationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanSubClassification(int? classificationId);

        /// <summary>
        /// The fetch Scan sub Classification tests.
        /// </summary>
        /// <param name="locationId"></param>
        /// <param name="classificationId"></param>
        /// <param name="subClassificationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchSubClassificationTests(int? locationId, int? classificationId, int? subClassificationId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchOTRoomSurgeriesAsync(string? surgeryId, string? otRoomId);

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanTestCategoryTypesAsync(int? scanTestMasterId, int? locationId);

        /// <summary>
        /// The fetch charge category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ChargeCategoryAsync();
        /// <summary>
        /// The fetch practice locations.
        /// </summary>
        /// <param name="practiceId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> LocationsForPracticeAsync(int practiceId);

        /// <summary>
        /// Fetches the locations for practice asynchronous.
        /// </summary>
        /// <param name="providerId"></param>
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationsForPracticeAsync(int? providerId);


        /// <summary>
        /// The fetch pay category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanAvailabilityStatus();

        /// <summary>
        /// The fetch pay category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanAvailabilityReason();

        /// <summary>
        /// The fetch scan scroll result.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchScanScrollResult();
        /// <summary>
        /// The fetch charge category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationChargeCategoryAsync(int? locationId);

        /// <summary>
        /// The fetch charge category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchCaseTypes();
        /// <summary>
        /// The fetch charge category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchEmergencyCaseTypes();
        /// <summary>
        /// The fetch otroom async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchOTRoomAsync(int? locationId);
        /// <summary>
        /// The surgery names async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> SurgeryNamesAsync();
        /// <summary>
        /// The providers async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProvidersForOTAsync(int? locationId);
        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchUsersAllAsync(int roleId, int? locationId);


        /// <summary>
        /// The fetch id proofs.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchIdProofsAsync();

        /// <summary>
        /// The fetch rooms.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchRoomsAsync();
        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchPatientNameMobileAsync(string filter, int locationId, string fromDate, string toDate, string toDay);


        Task<IEnumerable<Resource>> FetchAnaesthesiaTypesAsync();
        /// <summary>
        /// The fetch patient.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchsurgerisAsync(int id);
        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationSurgeryAsync(int? locationId);

        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchUniqueOTRooms(int? locationId);

        /// <summary>
        /// The fetch discounts.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchDiscountModule();

        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAdmissionPayTypes();

        /// <summary>
        /// Fetches the patient details.
        /// </summary>
        /// <param name="patientId">The patient identifier.</param>
        /// <returns></returns>
        Task<Patient> FetchPatientDetails(int patientId);

        /// <summary>
        /// The fetch session types.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchSessionTypesAsync();

        /// <summary>
        /// Fetches the provider specialization all consulation types.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ProviderSpecializationConsultationtypeModel>> FetchProviderSpecializationAllConsulationTypes(ProviderSpecializationConsultationtypeModel model);

        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchNewPatientAppointmentAsync(int? patientId);

        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchReferralDoctorAsync();


        /// <summary>
        /// fetch visit types
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> VisitTypesAsync();


        /// <summary>
        /// Fetches the tpa companies asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchTpaCompaniesAsync();

        /// <summary>
        /// Fetches the default charge category asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<Resource> FetchDefaultChargeCategoryAsync();

        /// <summary>
        /// The fetch pay category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchDoctorWeek();

        /// <summary>
        /// fetch out patients
        /// </summary>
        /// <param name="searchParam"></param>
        /// <param name="locationId"></param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> OutPatientsAsync(string? searchParam, int locationId);

        /// <summary>
        /// The fetch pay category.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchHealthCardAsync();
        /// <summary>
        /// The  fetch provider.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchSurgeryAsync(int? locationId);


        /// <summary>
        ///
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> AmbulancesAsync(string? searchParam, int locationId);


        Task<IEnumerable<Resource>> DriverDetailAsync(string? searchParam);
        /// <summary>
        /// The  fetch reason.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchReasons();
        /// <summary>
        /// The  fetch authority.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchAuthorityMasters();
        /// <summary>
        /// The  fetch doctor unit.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchDoctorUnit(int? locationId);


        /// <summary>
        /// The  fetch provider whos signature is not null.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProviderSignature();

        /// <summary>
        /// The  fetch provider whos signature is not null.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchConsultDoctors(string? searchParam, int locationId);

        /// <summary>
        /// Fetches the medication frequency asynchronous.
        /// </summary>
        /// <param name="type">The type.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchMedicationFrequencyAsync(string type);

        /// <summary>
        ///
        /// </summary>
        /// <param name="searchParam"></param>
        /// <param name="fromDate"></param>
        /// <param name="toDate"></param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchRegisteredPatientsAsync(string? searchParam, string? fromDate, string? toDate);

        /// <summary>
        /// The fetch radiology orders.
        /// </summary>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProviderLocationsAsync(int? providerId, int? locationId);

        /// <summary>
        /// Fetches the medication frequency asynchronous.
        /// </summary>
        /// <param name="type">The type.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchSpecializationProviderAsync(int? specializationId);

        /// <summary>
        /// Fetches the scan distinct out patients asynchronous
        /// </summary>
        /// <param name="fromDate">fromDate.</param>
        /// <param name="toDate"> toDate.</param>
        /// <param name="locationId"> locationId.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> ScanDistinctOutPatients(string fromDate, string toDate, int locationId);

        /// <summary>
        /// Fetches the scan distinct patients for bulk reschedule or cancel filters.
        /// </summary>
        /// <param name="fromDate">fromDate.</param>
        /// <param name="toDate"> toDate.</param>
        /// <param name="locationId"> locationId.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> ScanBulkRCPatients(string fromDate, string toDate, int locationId);

        Task<IEnumerable<Resource>> PackageModules(int locationId, string packageType, string moduleType);
        Task<IEnumerable<Resource>> CounsellingTypes();
        Task<IEnumerable<Resource>> PackageTypes();
        Task<IEnumerable<Resource>> ModuleTypes();

        /// <summary>
        /// Fetches the diet guidlines asynchronous
        /// </summary>

        /// <returns></returns>
        Task<IEnumerable<Resource>> DietGuidlines(int? typeId);
        /// <summary>
        /// Fetches the diet guidlines asynchronous
        /// </summary>

        /// <returns></returns>
        Task<IEnumerable<Resource>> DietTypes();


        Task<IEnumerable<Resource>> FetchPatientAppointmentAsync(string filter, int locationId, string fromDate, string toDate, string toDay);


        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="searchParam">
        /// The search param.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> DoctorAppointmentNoticeAsync(int? locationId, int? providerId, string? appointmentDate);

        /// <summary>
        /// The patients async.
        /// </summary>
        /// <param name="locationId">
        /// The locationId.
        /// </param>
        /// <param name="machineId">
        /// The machine Id.
        /// </param>
        /// <param name="appointmentDate">
        /// The appointment Date.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> ScanAppointmentNoticeAsync(int? locationId, int? machineId, string appointmentDate);


        /// <summary>
        /// Fetches the location practice.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchEmergencyDetailAsync(int? emergencyTypeId);

        /// <summary>
        /// Fetches the lab vacutainers asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchLabVacutainersAsync();

        /// <summary>
        /// Fetches the patient ANC number asynchronous.
        /// </summary>
        /// <param name="patientId">
        /// The Patient Id.
        /// </param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchAncNumberAsync(int patientId);

        /// <summary>Fetches the patient BMI number asynchronous.</summary>
        /// <param name="patientId">The Patient Id.</param>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchPatientBMI(int patientId);

        /// <summary>
        /// Locationses the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> PatientRegistrationChargeAsync(int locationId);

        /// <summary>
        /// fetch encounter lookup asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchEncounterLookup();

        /// <summary>
        /// fetch encounter lookup asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchEncounterLookUpValues(int encounterLookUpId);

        /// <summary>The fetch of scan machines based on test.</summary>
        /// <param name="locationId"></param>
        /// <param name="scanTestMasterId"></param>
        /// <returns>The <see cref="Task"/></returns>
        Task<IEnumerable<Resource>> FetchScanTestMachinesAsync(int? locationId, int? scanTestMasterId);

        /// <summary>The fetch of scan machines based on test.</summary>
        /// <param name="locationId"></param>
        /// <param name="searchParams"></param>
        /// <returns>The <see cref="Task"/></returns>
        Task<IEnumerable<Resource>> FetchAdmissionPatients(string? searchParams, int? locationId);
        /// <summary>The fetch of scan machines based on test.</summary>
        /// <param name="parentPatientId"></param>
        /// <returns>The <see cref="Task"/></returns>
        Task<IEnumerable<Resource>> FetchParentPatients(int? parentPatientId);

        /// <summary>
        /// Fetches the labmasters asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchLabMastersAsync();
        /// <summary>
        /// Fetches the warehouse asynchronous.
        /// </summary>
        /// <returns></returns>
       
 
       // Task<IEnumerable<Resource>> FetchWareHouseRetailStoreAsync(int locationId);

        Task<IEnumerable<Resource>> FetchWareHousesAsync(int id);
        
        Task<IEnumerable<Resource>> FetchRetailsAsync(int wId);

        Task<IEnumerable<Resource>> FetchTemplatesAsync();

        Task<IEnumerable<Resource>> FetchModulesMasterAsync();

        Task<IEnumerable<Resource>> FetchAllLabAsync();

        /// <summary>
        /// The fetch providers.
        /// </summary>
        /// <param name="departmentId">
        /// The provider Id.
        /// </param>
        /// <param name="locationId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchProvidersLocation(int? departmentId, int? locationId);

        /// <summary>
        /// Fetches the lab external agencies asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchAllActiveLabExternalAgenciesAsync();

        /// <summary>
        /// Fetches all lab external agencies asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource>> FetchAllLabExternalAgenciesAsync();


        /// <summary>
        /// The fetch otroom async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchLocationChargeTemplateAsync(int? admissionPayTypeId, int? locationId);

        /// <summary>
        /// The fetch diet conditions.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<Resource>> FetchDietConditions();

    }
}