﻿namespace Hims.Infrastructure.Helpers.Models
{
    using System;
    using System.Diagnostics.CodeAnalysis;
    using Newtonsoft.Json;

    /// <summary>
    /// The push notification request model.
    /// </summary>
    public class PushNotificationRequestModel
    {
        /// <summary>
        /// Gets or sets the data.
        /// </summary>
        [JsonProperty("data")]
        public Data Data { get; set; }

        /// <summary>
        /// Gets or sets the notification.
        /// </summary>
        [JsonProperty("notification")]
        public Notification Notification { get; set; }

        /// <summary>
        /// Gets or sets the registration ids.
        /// </summary>
        [JsonProperty("registration_ids")]
        public string[] RegistrationIds { get; set; }
        public bool ContentAvailable { get; internal set; }
        public string CollapseKey { get; internal set; }
    }

    /// <summary>
    /// The push notification intimate model.
    /// </summary>
    public class PushNotificationIntimateModel
    {
        /// <summary>
        /// Gets or sets the data.
        /// </summary>
        [JsonProperty("data")]
        public IntimateData Data { get; set; }

        /// <summary>
        /// Gets or sets the notification.
        /// </summary>
        [JsonProperty("notification")]
        public Notification Notification { get; set; }

        /// <summary>
        /// Gets or sets the registration ids.
        /// </summary>
        [JsonProperty("registration_ids")]
        public string[] RegistrationIds { get; set; }
    }

    /// <summary>
    /// The push notification request model.
    /// </summary>
    public class PushNotificationDataModel
    {
        /// <summary>
        /// Gets or sets the data.
        /// </summary>
        [JsonProperty("data")]
        public object Data { get; set; }

        /// <summary>
        /// Gets or sets the notification.
        /// </summary>
        [JsonProperty("notification")]
        public Notification Notification { get; set; }

        /// <summary>
        /// Gets or sets the registration ids.
        /// </summary>
        [JsonProperty("registration_ids")]
        public string[] RegistrationIds { get; set; }
    }

    /// <summary>
    /// The intimate data.
    /// </summary>
    public class IntimateData
    {
        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        [JsonProperty("message")]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        [JsonProperty("type")]
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        [JsonProperty("id")]
        public string Id { get; set; }
    }

    /// <summary>
    /// The data.
    /// </summary>
    [SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1402:FileMayOnlyContainASingleClass", Justification = "Reviewed. Suppression is OK here.")]
    public class Data
    {
        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        [JsonProperty("message")]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        [JsonProperty("type")]
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        [JsonProperty("roomName")]
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        [JsonProperty("originalRoomName")]
        public string OriginalRoomName { get; set; }

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        [JsonProperty("doctorName")]
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the sinch.
        /// </summary>
        [JsonProperty("sinch")]
        public object Sinch { get; set; }

        /// <summary>
        /// Gets or sets the chat.
        /// </summary>
        [JsonProperty("chat")]
        public object Chat { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        [JsonProperty("source")]
        public object Source { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        [JsonProperty("date")]
        public string Date { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        [JsonProperty("previousDate")]
        public string PreviousDate { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        [JsonProperty("callerId")]
        public int CallerId { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        [JsonProperty("telemedicineId")]
        public int TelemedicineId { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        [JsonProperty("domain")]
        public string Domain { get; set; }
        public bool StartAudioOnly { get; internal set; }
    }
    
    /// <summary>
    /// The notification data.
    /// </summary>
    [SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1402:FileMayOnlyContainASingleClass", Justification = "Reviewed. Suppression is OK here.")]
    public class NotificationData
    {
        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        [JsonProperty("message")]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        [JsonProperty("content")]
        public object Content { get; set; }
    }

    /// <summary>
    /// The notification.
    /// </summary>
    public class Notification
    {
        /// <summary>
        /// Gets or sets the title.
        /// </summary>
        [JsonProperty("title")]
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the body.
        /// </summary>
        [JsonProperty("body")]
        public string Body { get; set; }

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        [JsonProperty("icon")]
        public string Icon { get; set; }

        /// <summary>
        /// Gets or sets the icon.
        /// </summary>
        [JsonProperty("sound")]
        public string Sound { get; set; }
        public int Badge { get; internal set; }
        public string Tag { get; internal set; }
    }
}
