﻿namespace Hims.Shared.UserModels.PayU
{
    using System;

    /// <summary>
    /// The transaction detail.
    /// </summary>
    public class TransactionDetail
    {
        /// <summary>
        /// Gets or sets the txn id.
        /// </summary>
        public int? TxnId { get; set; }

        /// <summary>
        /// Gets or sets the batch id.
        /// </summary>
        public string BatchId { get; set; }

        /// <summary>
        /// Gets or sets the merchant ref id.
        /// </summary>
        public string MerchantRefId { get; set; }

        /// <summary>
        /// Gets or sets the purpose.
        /// </summary>
        public string Purpose { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Amount { get; set; }

        /// <summary>
        /// Gets or sets the txn status.
        /// </summary>
        public string TxnStatus { get; set; }

        /// <summary>
        /// Gets or sets the txn date.
        /// </summary>
        public DateTime TxnDate { get; set; }

        /// <summary>
        /// Gets or sets the payu transaction ref no.
        /// </summary>
        public string PayuTransactionRefNo { get; set; }

        /// <summary>
        /// Gets or sets the beneficiary name.
        /// </summary>
        public string BeneficiaryName { get; set; }

        /// <summary>
        /// Gets or sets the msg.
        /// </summary>
        public string Msg { get; set; }

        /// <summary>
        /// Gets or sets the response code.
        /// </summary>
        public string ResponseCode { get; set; }

        /// <summary>
        /// Gets or sets the transfer type.
        /// </summary>
        public string TransferType { get; set; }

        /// <summary>
        /// Gets or sets the bank transaction ref no.
        /// </summary>
        public string BankTransactionRefNo { get; set; }
    }
}