﻿using System;

namespace Hims.Shared.UserModels.ProviderScheduleCharges
{

    /// <summary>
    /// The coupon.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int? ProviderScheduleChargeId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int ProviderAvailabilityChargeTypeId { get; set; }
        /// <summary>
        /// Gets or sets the parts of day id.
        /// </summary>
        public int? PartsOfDayId { get; set; }
        /// <summary>
        /// Gets or sets the consultation type id.
        /// </summary>
        public int? ConsultationTypeId { get; set; }
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int? Id { get; set; }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// Gets or sets the consultation name.
        /// </summary>
        public string ConsultationName { get; set; }
        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }
        /// <summary>
        /// Gets or sets the charge names.
        /// </summary>
        public string ChargeNames { get; set; }
        /// <summary>
        /// Gets or sets the created by names.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public string ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// gets or sets charge types id.
        /// </summary>
        public int ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the charge.
        /// </summary>
        public int Charge { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int Value { get; set; }
        /// <summary>
        /// Gets or sets the Specialization Charge.
        /// </summary>
        public string SpecializationCharge { get; set; }

        /// <summary>
        /// Gets or sets the Visit Type Id.
        /// </summary>
        public int VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the visit type duration.
        /// </summary>
        public string VisitTypeDuration { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the provider available solt id.
        /// </summary>
        public int? ProviderAvailabilitySlotId { get; set; }
        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }
        /// <summary>
        /// Gets or sets the available day.
        /// </summary>
        public string? AvailableDay { get; set; }
        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public string? StartTime { get; set; }
        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public string? EndTime { get; set; }
        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime StartDate { get; set; }
        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime EndDate { get; set; }
        /// <summary>
        /// Gets or sets the charge name.
        /// </summary>
        public string ChargeName { get; set; }

        public Boolean Active { get; set; }

        public string SchedulerTypeId { get; set; }
        public string FullName { get; set; }


        /// <summary>
        /// Gets or sets the followup days
        /// </summary>
        public int? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the follow up days limit.
        /// </summary>
        public int? FollowUpDaysLimit { get; set; }
    }
}
