﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class Appointment
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [Key, Identity]
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public char? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public char? ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the old appointment date.
        /// </summary>
        public DateTime OldAppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the old appointment time.
        /// </summary>
        public TimeSpan OldAppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment notes.
        /// </summary>
        public string? AppointmentNotes { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }
        
        /// <summary>
        /// Gets or sets the app charges.
        /// </summary>
        public decimal AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the wallet amount.
        /// </summary>
        public decimal? WalletAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; } = "B";

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the cancel reason.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the reschedule reason.
        /// </summary>
        public string? RescheduleReason { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        ///  Gets or sets payment type.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        ///  Gets or sets payment type.
        /// </summary>
        public char? PaymentType { get; set; }

        /// <summary>
        ///  Gets or sets payment number.
        /// </summary>
        public string? PaymentNumber { get; set; }

        /// <summary>
        ///  Gets or sets follow up for AppointmentId.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        ///  Gets or sets follow up for admission id.
        /// </summary>
        public int? FollowUpForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the old appointment date.
        /// </summary>
        public DateTime? CheckedIn { get; set; }

        /// <summary>
        /// Gets or sets the old appointment date.
        /// </summary>
        public DateTime? CheckedOut { get; set; }

        /// <summary>
        /// Gets or sets the old appointment date.
        /// </summary>
        public int? Tat { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment type id from appointmentType masters.
        /// </summary>
        public int? AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the Pay type id from payType masters.
        /// </summary>
        public int? PayTypeId { get; set; }
        public int TokenNumber { get; set; }
        public int QueueStatusId { get; set; }
        public DateTime? QueueEndDate { get; set; }
        public DateTime? QueueStartDate { get; set; }
        public int? WaitingCount { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        public int ProviderAvailabilityId { get; set; }

        public int ConsultationTypeId { get; set; }
        public bool IsEncounter { get; set; }

        public int? CubicleId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAppointment { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int? DoctorSpecializationChargeModuleDetailsId { get; set; }
        //public string? EncryptedProviderId { get; set; }
        //public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the other remarks.
        /// </summary>
        /// <value>
        /// The other remarks.
        /// </value>
        public string? OtherRemarks { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? AuthorityMasterId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReasonsId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string? Remarks { get; set; }

        /// <summary>
        /// Gets or sets the anc card generation id.
        /// </summary>
        public int? ANCCardGenerationId { get; set; }

        /// <summary>
        /// Gets or sets the is emergency.
        /// </summary>
        public bool IsEmergency { get; set; }

        /// <summary>
        /// Gets or sets the discount in percentage.
        /// </summary>
        public decimal? DiscountInPercentage { get; set; }
        /// <summary>
        /// Gets or sets the discount in percentage.
        /// </summary>
        public bool? IsHealthCard { get; set; }

        /// <summary>
        /// Gets or sets the session id.
        /// </summary>
        public int? SessionId { get; set; }
    }
}
