﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    public class PatientTiming
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        [Key, Identity]
        public int PatientTimingId { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the breakfast.
        /// </summary>
        /// <value>
        /// The breakfast.
        /// </value>
        public TimeSpan? Breakfast { get; set; }

        /// <summary>
        /// Gets or sets the lunch.
        /// </summary>
        /// <value>
        /// The lunch.
        /// </value>
        public TimeSpan? Lunch { get; set; }

        /// <summary>
        /// Gets or sets the dinner.
        /// </summary>
        /// <value>
        /// The dinner.
        /// </value>
        public TimeSpan? Dinner { get; set; }
    }
}