﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Inventory;
    using Hims.Shared.UserModels.Pharmacy;
    using Shared.UserModels.OperationTheater;

    /// <summary>
    /// The IssueService interface.
    /// </summary>
    public interface IIssueService
    {
        /// <summary>
        /// Approves the ot indents.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ApproveOTIndents(OTIssueModel model);

        /// <summary>
        /// Approves the pharmacy indents.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ApprovePharmacyIndents(OTIssueModel model);

        /// <summary>
        /// Fetches the data for issued stock acknowledgment.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyIssuedStockHeaderModel>> FetchDataForIssuedStockAcknowledgment(PharmacyIssuedStockHeaderModel model);

        /// <summary>
        /// Acknowledes the received products asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AcknowledeReceivedProductsAsync(PharmacyIssuedStockHeaderModel model);

        /// <summary>
        /// Approves the inventory indents.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ApproveInventoryIndents(OTIssueModel model);

        /// <summary>
        /// Fetches the data for inventory issued stock acknowledgment asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<InventoryIssuedStockHeaderModel>> FetchDataForInventoryIssuedStockAcknowledgmentAsync(InventoryIssuedStockHeaderModel model);

        /// <summary>
        /// Acknowledes the received products inventory asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AcknowledeReceivedProductsInventoryAsync(InventoryIssuedStockHeaderModel model);

        /// <summary>
        /// Retails the ware house link identifier asynchronous.
        /// </summary>
        /// <param name="wareHouseId">The ware house identifier.</param>
        /// <param name="retailPharmacyId">The retail pharmacy identifier.</param>
        /// <returns></returns>
        Task<int> RetailWareHouseLinkIdAsync(int wareHouseId, int retailPharmacyId);

        /// <summary>
        /// Adds the retail store stock from excel sheet.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddRetailStoreStockFromExcelSheetAsync(PharmacyRetailStockModel model);

        /// <summary>
        /// Adds the stocks to retail via purchase bill asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddStocksToRetailViaPurchaseBillAsync(PharmacyPurchaseBill model);
    }
}
