﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The component type.
    /// </summary>
    [Table("ComponentType", Schema = "template")]

    public class ComponentType
    {
        /// <summary>
        /// Gets or sets the component type id.
        /// </summary>
        [Key, Identity]
        public int ComponentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }
        

        /// <summary>
        /// Gets or sets a value sub name.
        /// </summary>
        public string SubName { get; set; }

    }
}
