﻿namespace Hims.Domain.Entities
{
    using Shared.Dapper.Attributes;

    using System;
    using System.ComponentModel.DataAnnotations;

    public class EmployeeShift
    {
        /// <summary>
        /// Gets or sets the employee shift id.
        /// </summary>
        [Key, Identity]
        public int EmployeeShiftId { get; set; }

        /// <summary>
        /// Gets or sets the widget name.
        /// </summary>
        public string EmployeeShiftName { get; set; }

        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public TimeSpan StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public TimeSpan EndTime { get; set; }

        /// <summary>
        /// Gets or sets the note.
        /// </summary>
        public string Note { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }
    }
}
