﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The excel upload history.
    /// </summary>
    public class ExcelUploadHistory
    {
        /// <summary>
        /// Gets or sets the excel upload history id.
        /// </summary>
        [Key, Identity]
        public int ExcelUploadHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by.
        /// </summary>
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the sheet name.
        /// </summary>
        public string SheetName { get; set; }

        /// <summary>
        /// Gets or sets the type of.
        /// </summary>
        public string TypeOf { get; set; }

        /// <summary>
        /// Gets or sets the added products.
        /// </summary>
        public string AddedProducts { get; set; }

        /// <summary>
        /// Gets or sets the sheet type
        /// </summary>
        public string SheetType { get; set; }

        /// <summary>
        /// Gets or sets the product status.
        /// </summary>
        public string ProductStatus { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
    }
}
