﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The health card.
    /// </summary>
    public class HealthCard
    {
        /// <summary>
        /// Gets or sets the health card id.
        /// </summary>
        [Key, Identity]
        public int HealthCardId { get; set; }

        /// <summary>
        /// Gets or sets the health card name.
        /// </summary>
        public string HealthCardName { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double? Amount { get; set; }

        /// <summary>
        /// Gets or sets the allow members.
        /// </summary>
        public int AllowMembers { get; set; }

        /// <summary>
        /// Gets or sets the validity Type.
        /// </summary>
        public string ValidityType { get; set; }
        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int Duration { get; set; }
        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]

        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

    }
}
