﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;


    /// <summary>
    /// The lab booking status.
    /// </summary>
    public class LabBookingStatus
    {
        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        [Key,Identity]
        public int LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabBookingStatus"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the colour.
        /// </summary>
        /// <value>
        /// The colour.
        /// </value>
        public string RowColor { get; set; }
    }
}
