﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The sale return detail.
    /// </summary>
    public class SaleReturnDetail
    {
        /// <summary>
        /// Gets or sets the sale return detail id.
        /// </summary>
        [Key, Identity]
        public int SaleReturnDetailId { get; set; }

        /// <summary>
        /// Gets or sets the sale return header id.
        /// </summary>
        public int SaleReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public double TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the pay type identifier.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string PaymentNumber { get; set; }
    }
}
