﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The ticket assignee.
    /// </summary>
    public class TicketAssignee
    {
        /// <summary>
        /// Gets or sets the ticket timeline id.
        /// </summary>
        [Key, Identity]
        public long TicketAssigneeId { get; set; }

        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        public long TicketId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }
        
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the assigned date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the assignee account id.
        /// </summary>
        public int? AssigneeAccountId { get; set; }
    }
}