﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.Common;
    using Shared.EntityModels;
    using Shared.Library.Enums;

    /// <summary>
    /// The AccountSessionService interface.
    /// </summary>
    public interface IAccountSessionService
    {
        /// <summary>
        /// The fetch sessions async.
        /// </summary>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AccountSessionModel>> FetchAsync(int accountId);

        /// <summary> The fetch device token async.</summary>
        /// <param name="referenceId"> The reference id.</param>
        /// <param name="role"> The role.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<IEnumerable<AccountSessionModel>> FetchDeviceTokenAsync(int referenceId, Roles role);

        /// <summary>
        /// The get session async.
        /// </summary>
        /// <param name="accountSessionId">
        /// The account session id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AccountSessionModel> FindAsync(int accountSessionId);

        /// <summary>
        /// The create async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateAsync(AccountSessionModel model);

        /// <summary>
        /// The delete session async.
        /// </summary>
        /// <param name="accountSessionId">
        /// The account session id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int accountSessionId);

        /// <summary>
        /// The delete session async.
        /// </summary>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <param name="deviceType">
        /// The device type.
        /// </param>
        /// <param name="deviceId">
        ///  The device id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int accountId, DeviceType deviceType, string deviceId);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <param name="deviceToken">
        /// The device token.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int accountId, string deviceToken);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="accountId">
        /// The account id
        /// </param>
        /// <param name="deviceType">
        /// The device type
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> WebLogoutAsync(int accountId, DeviceType deviceType);

        /// <summary>
        /// The delete all sessions async.
        /// </summary>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAllAsync(int accountId);

        /// <summary> The delete others async.</summary>
        /// <param name="accountId"> The account id.</param>
        /// <param name="deviceId"> The device id.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<int> DeleteOthersAsync(int accountId, string deviceId);
    }
}