﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;

    using Shared.Library;
    using Shared.Library.Enums;
    using Shared.UserModels;

    using Hims.Shared.EntityModels;
    using Hims.Shared.Library.Helpers;

    /// <summary>
    /// The DentalEncounterService interface.
    /// </summary>
    public interface IDentalEncounterService
    {
        /// <summary>
        /// The add alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAltAsync(DentalEncounterModifyModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAltAsync(DentalEncounterModifyModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <param name="type">
        /// The type.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DentalEncounterResource> FetchAsync(int appointmentId, DentalEncounterType type);

        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DentalEncounterModel> FindAsync(int appointmentId);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(DentalEncounterModifyModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(DentalEncounterModifyModel model);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="dentalEncounterId">
        /// The dental encounter id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int dentalEncounterId);

        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DentalFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);

        /// <summary>
        /// The find prescription async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DentalPrescriptionModel> FindPrescriptionAsync(int appointmentId);
    }
}
