﻿namespace Hims.Infrastructure.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;

    using Hims.Domain.Configurations;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Domain.Services;
    using Hims.Shared.EntityModels;

    /// <summary> The chat service.</summary>
    public class IconService : IIconService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <summary>
        /// The amazon s 3 configuration.
        /// </summary>
        private readonly IAmazonS3Configuration amazonS3Configuration;

        /// <inheritdoc cref="IIconService" />
        public IconService(IUnitOfWork unitOfWork, IAmazonS3Configuration amazonS3Configuration)
        {
            this.unitOfWork = unitOfWork;
            this.amazonS3Configuration = amazonS3Configuration;
        }

        /// <inheritdoc/>
        public Task<int> AddIcons(IconsModel model)
        {
            var request = new Icons
            {
                Active = true,
                IconName = model.IconName
            };
            return this.unitOfWork.Icons.InsertAsync(request);
        }

        /// <inheritdoc/>
        public async Task<IEnumerable<IconsModel>> FetchIcons(int pageSize, int pageIndex)
        {
            pageIndex = pageIndex > 0 ? pageIndex - 1 : pageIndex;
            var query =
                $@"Select count(""IconsId"") over() as ""TotalItems"",""IconsId"",""IconName"",""IconName"" AS ""Url"" from ""Icons"" order by ""IconsId"" desc limit {pageSize} offset {pageIndex * pageSize}";
            return await this.unitOfWork.Current.QueryAsync<IconsModel>(query);
        }

        /// <inheritdoc/>
        public async Task<int> DeleteIconsAsync(int iconId)
        {
            var query = $@"Delete from ""Icons"" where ""IconsId"" = {iconId} ";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }
    }
}
