﻿import { Directive, HostListener } from "@angular/core";
import { KeyCodesHelper, RegExHelper } from "@shared/helpers";

@Directive({
    selector: "[decimalsOnly]"
})
export class DecimalsOnlyDirective {
    @HostListener("keydown", ["$event"])
    onKeyDown(e: KeyboardEvent) {
        const keys = KeyCodesHelper.default.concat(KeyCodesHelper.numbers).concat(KeyCodesHelper.dots);
        if (keys.indexOf(e.keyCode) === -1) {
            event.preventDefault();
        }

        if (KeyCodesHelper.defaultNames.indexOf(e.key) === -1) {
            return;
        }

        if (RegExHelper.decimalsOnly.test(e.key))
            return;
        else
            event.preventDefault();
    }
}