﻿import { Injectable } from "@angular/core";
import * as bootbox from "bootbox";
import { ToastrService } from "ngx-toastr";

function emptyFunction() { }

@Injectable()
export class NotifyService {
    constructor(private readonly toastrService: ToastrService) { }
    hideAll() {
        return bootbox.hideAll();
    }

    warningToast(message: string) {
        this.toastrService.warning(message, "Warning!");
    }

    infoToast(message: string) {
        this.toastrService.info(message, "Information!");
    }

    successToast(message: string) {
        this.toastrService.success(message, "Success!");
    }

    errorToast(message: string) {
        this.toastrService.error(message, "Error!");
    }

    defaultErrorToast() {
        this.toastrService.error("Sorry! Error occurred. Please try again later.", "Error!");
    }

    warning(message: string, callback?: any) {
        message = message || "Warning";
        return bootbox.dialog({
            title: `<i class="fe-alert-triangle h1 text-warning"></i>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Ok",
                    className: "btn-sm btn-warning",
                    callback: callback === null ? emptyFunction : callback
                }
            }
        });
    }

    info(message: string, callback?: any) {
        message = message || "Information";
        return bootbox.dialog({
            title: `<i class="fe-info h1 text-info"></i>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Ok",
                    className: "btn-sm btn-info",
                    callback: callback === null ? emptyFunction : callback
                }
            }
        });
    }

    success(message: string, callback?: any) {
        message = message || "Success";
        return bootbox.dialog({
            title: `<i class="fe-check-circle h1 text-success"></i>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Ok",
                    className: "btn-sm btn-success",
                    callback: callback === null ? emptyFunction : callback
                }
            }
        });
    }
    error(message: string, callback?: any) {
        message = message || "Error";
        return bootbox.dialog({
            title: `<i class="fe-alert-circle h1 text-danger"></i>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Ok",
                    className: "btn-sm btn-danger",
                    callback: callback === null ? emptyFunction : callback
                }
            }
        });
    }

    defaultError(callback?: any) {
        return bootbox.dialog({
            title: `<i class="fe-alert-circle h1 text-danger"></i>`,
            message: "Sorry error occurred. Please try again later.",
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Ok",
                    className: "btn-sm btn-danger",
                    callback: callback === null ? emptyFunction : callback
                }
            }
        });
    }

    delete(yesCallback?: any, noCallback?: any) {
        return bootbox.dialog({
            title: `<i class="fe-help-circle h1 text-danger"></i><h4>Are you sure?</h4>`,
            message: "Do you really want to delete this record? This process cannot be undone.",
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Yes! Delete",
                    className: "btn-sm btn-danger mr-1",
                    callback: yesCallback === null ? emptyFunction : yesCallback
                },
                no: {
                    label: "No! Cancel",
                    className: "btn-sm btn-light",
                    callback: noCallback === null ? emptyFunction : noCallback
                }
            }
        });
    }

    confirm(message: string, yesCallback?: any, noCallback?: any) {
        return bootbox.dialog({
            title: `<i class="fe-help-circle h1 text-danger"></i><h4>Are you sure?</h4>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Yes! Confirm",
                    className: "btn-sm btn-success mr-1",
                    callback: yesCallback === null ? emptyFunction : yesCallback
                },
                no: {
                    label: "No! Cancel",
                    className: "btn-sm btn-danger",
                    callback: noCallback === null ? emptyFunction : noCallback
                }
            }
        });
    }

    advancedConfirm(message: string, yesLabel: string, yesCallback?: any) {
        return bootbox.dialog({
            title: `<i class="fe-help-circle h1 text-primary"></i><h4>Are you sure?</h4>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: yesLabel,
                    className: "btn-sm btn-primary mr-1",
                    callback: yesCallback === null ? emptyFunction : yesCallback
                }
            }
        });
    }

    endCallConfirm(message: string, endMeetingCallback?: any, leaveMeetingCallback?: any) {
        return bootbox.dialog({
            title: `<i class="fe-help-circle h1 text-primary"></i><h4>Are you sure?</h4>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "End Call",
                    className: "btn-sm btn-danger mr-1",
                    callback: endMeetingCallback === null ? emptyFunction : endMeetingCallback
                },
                leave: {
                    label: "Leave Call",
                    className: "btn-sm btn-warning mr-1",
                    callback: leaveMeetingCallback === null ? emptyFunction : leaveMeetingCallback
                },
                no: {
                    label: "Cancel",
                    className: "btn-sm btn-light"
                }
            }
        });
    }

    SampleAcceptionConfirm(message: string, endMeetingCallback?: any, leaveMeetingCallback?: any) {
        return bootbox.dialog({
            title: `<i class="fe-help-circle h1 text-primary"></i><h4>Are you sure?</h4>`,
            message: message,
            closeButton: false,
            className: "modal fade effect-scale",
            buttons: {
                yes: {
                    label: "Sample Accept",
                    className: "btn-sm btn-outline-success mr-1",
                    callback: endMeetingCallback === null ? emptyFunction : endMeetingCallback
                },
                leave: {
                    label: "Sample Reject",
                    className: "btn-sm btn-outline-danger mr-1",
                    callback: leaveMeetingCallback === null ? emptyFunction : leaveMeetingCallback
                },
                no: {
                    label: "Back",
                    className: "btn-sm btn-light"
                }
            }
        });
    }
}