﻿namespace Hims.Shared.Dapper.SqlGenerator
{
    using System.ComponentModel.DataAnnotations.Schema;
    using System.Reflection;

    using Attributes;

    /// <summary>
    ///     Metadata from PropertyInfo
    /// </summary>
    public class SqlPropertyMetadata
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SqlPropertyMetadata"/> class.
        /// Constructor
        /// </summary>
        /// <param name="propertyInfo">
        /// The property Info.
        /// </param>
        public SqlPropertyMetadata(PropertyInfo propertyInfo)
        {
            this.PropertyInfo = propertyInfo;
            var alias = this.PropertyInfo.GetCustomAttribute<ColumnAttribute>();
            if (!string.IsNullOrEmpty(alias?.Name))
            {
                this.Alias = alias.Name;
                this.ColumnName = this.Alias;
            }
            else
            {
                this.ColumnName = this.PropertyInfo.Name;
            }

            var ignoreUpdate = this.PropertyInfo.GetCustomAttribute<IgnoreUpdateAttribute>();
            if (ignoreUpdate != null)
            {
                this.IgnoreUpdate = true;
            }
        }

        /// <summary>
        /// Gets the property info.
        /// </summary>
        public PropertyInfo PropertyInfo { get; }

        /// <summary>
        /// Gets or sets the alias.
        /// </summary>
        public string Alias { get; set; }

        /// <summary>
        /// Gets or sets the column name.
        /// </summary>
        public string ColumnName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether ignore update.
        /// </summary>
        public bool IgnoreUpdate { get; set; }

        /// <summary>
        /// The property name.
        /// </summary>
        public virtual string PropertyName => this.PropertyInfo.Name;
    }
}