﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class ShiftModel
    {
        /// <summary>
        /// Gets or sets the shift id.
        /// </summary>
        public int? ShiftId { get; set; }

        /// <summary>
        /// Gets or sets the widget name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }
        
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the log from.
        /// </summary>
        public short? LogFrom { get; set; }

        /// <summary>
        /// gets or sets the slot id's.
        /// </summary>
        public List<int> Slots { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }
    }
}
