﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class AdmissionReportModel
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted admission id.
        /// </summary>
        public string EncryptedAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the wardid.
        /// </summary>
        public string? FloorName { get; set; }

        /// <summary>
        /// Gets or sets the wardid.
        /// </summary>
        public string? CaseTypeName { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string AdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        public DateTime AdmissionDate { get; set; }
           
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }       

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }
     
        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }     

        /// <summary>
        /// Gets or sets the patient family member name.
        /// </summary>
        public string? FamilyMemberName { get; set; }

        /// <summary>
        /// Gets or sets the patient relation with family member.
        /// </summary>
        public string? Relation { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public int PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Religion { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Nationality { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Zipcode { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string City { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Area { get; set; }
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Entitlement { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string ReferBy { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string InsuranceCompanyName { get; set; }
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string RelationName { get; set; }
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string RelativeDOB { get; set; }
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string RelationMobile { get; set; }


        /// <summary>
        /// Gets or sets the ward name.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string RoomName { get; set; }
      
        /// <summary>
        /// Gets or sets the bed number. 
        /// </summary>
        public string BedNumber { get; set; }
    
        /// <summary>
        /// Gets or sets the surgery name.
        /// </summary>
        public string SurgeryName { get; set; }

        /// <summary>
        /// Gets or sets the attendant name
        /// </summary>
        public string? AttendantName { get; set; }

        /// <summary>
        /// Gets or sets the attendant contact no
        /// </summary>
        public string? AttendantContactNo { get; set; }
      
        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        public DateTime? DischargeDate { get; set; }
       
        /// <summary>
        /// Gets or sets the discharge status.
        /// </summary>
        public string DischargeStatus { get; set; }
      
        /// <summary>
        /// Gets or sets the UMR number.
        /// </summary>
        public string? UMRNo { get; set; }
        /// <summary>
        /// Gets or sets the UMR number.
        /// </summary>
        public string? Salutation { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationName { get; set; }
      
        /// <summary>
        /// Gets or sets the case type id.
        /// </summary>
        /// <value>
        /// The name of the case type id.
        /// </value>
        public int? CaseTypeId { get; set; }
      
        /// <summary>
        /// Gets or sets the insurance company Id.
        /// </summary>
        /// <value>
        /// The name of the insurance company Id.
        /// </value>
        public int? InsuranceCompanyId { get; set; }
           
        /// <summary>
        /// Gets or sets the patient organization.
        /// </summary>
        /// <value>
        /// The patient organization.
        /// </value>
        public string? PatientOrganization { get; set; }
       
    }
}
